@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">
    @include('layouts.user.header')
    <body
        class="main-bg main-bg-opac main-bg-blur adminuiux-sidebar-fill-white adminuiux-sidebar-boxed theme-blue roundedui"
        data-theme="theme-blue"
        data-sidebarfill="adminuiux-sidebar-fill-white"
        data-bs-spy="scroll"
        data-bs-target="#list-example"
        data-bs-smooth-scroll="true"
        tabindex="0"
    >
    @php
        $getFav = App\Models\WebsiteSettings::first();
    @endphp
        <div class="pageloader">
            <div class="container h-100">
                <div class="row justify-content-center align-items-center text-center h-100">
                    <div class="col-12 mb-auto pt-4"></div>
                    <div class="col-auto">
                        <img src="{{ url('upload/'.$getFav->website_favicon) }}"/>
                        <div class="loader10 mb-2 mx-auto"></div>
                    </div>
                    <div class="col-12 mt-auto pb-4"><p class="text-secondary">Please wait we are preparing awesome things to preview...</p></div>
                </div>
            </div>
        </div>
        <main class="flex-shrink-0 pt-0 h-100">
            <div class="container-fluid">
                <div class="auth-wrapper">
                    <div class="row gx-3">
                        <div class="col-12 col-md-6 col-xl-4 minvheight-100 d-flex flex-column px-0">
                            <header class="adminuiux-header">
                                <nav class="navbar">
                                    <div class="container-fluid">
                                        <a class="navbar-brand" href="investment-dashboard.html">
                                            <div class="d-block ms-3">
                                                <img src="{{ url('upload/'.$getSetting->website_logo) }}"/>
                                            </div>
                                        </a>
                                        <div class="ms-auto"></div>
                                        <div class="ms-auto"></div>
                                    </div>
                                </nav>
                            </header>
                            <div class="h-100 px-2 py-3">
                                <div class="row gx-3 h-100 align-items-center justify-content-center mt-md-3">
                                    <form method="POST" action="{{ route('login') }}">
                                        @csrf
                                    <div class="col-12 col-sm-8 col-md-11 col-xl-11 col-xxl-10 login-box">
                                        <div class="text-center mb-3">
                                            <h1 class="mb-2">Welcome&#9996;</h1>
                                            <p class="text-secondary">Enter your credential to login</p>
                                        </div>
                                        <div class="form-floating mb-3">
                                            <input class="form-control" type="email" value="{{ old('email') }}" required autofocus name="email" placeholder="{{ __('Email') }}" />
                                            <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                            <label for="emailadd">Email Address</label>
                                        </div>
                                        <div class="position-relative">
                                            <div class="form-floating mb-3">
                                                <input type="password" class="form-control" required autocomplete="current-password" name="password" placeholder="{{ __('Password') }}" />
                                                <x-input-error :messages="$errors->get('password')" class="mt-2" />
                                                <label for="passwd">Password</label>
                                            </div>
                                            <button class="btn btn-square btn-link text-theme-1 position-absolute end-0 top-0 mt-2 me-2"><i class="bi bi-eye"></i></button>
                                        </div>
                                        <div class="row gx-3 align-items-center mb-3">
                                            <div class="col">
                                                <div class="form-check">
                                                    <input class="form-check-input" id="remember_me" type="checkbox" name="remember" /> 
                                                    <label class="form-check-label" for="rememberme">Remember me</label></div>
                                                </div>
                                            <div class="col-auto">
                                                @if (Route::has('password.request'))
                                                    <a href="{{ route('password.request') }}" class="">Forget Password?</a>
                                                @endif
                                            </div>
                                            </div>
                                        <button type="submit" class="btn btn-lg btn-theme w-100 mb-3">Login</button>
                                        <div class="text-center mb-3">Don't have account? <a href="{{ url('register')}}" class="">Create Account</a></div>
                                    </div>
                                </form>
                                </div>
                            </div>
                            <footer class="adminuiux-footer mt-auto">
                                <div class="container-fluid text-center">
                                    <span class="small">Copyright @2024, <a href="https://adminuiux.com" target="_blank">InvestmentUX - Adminuiux</a> designed on Earth ❤️</span>
                                </div>
                            </footer>
                        </div>
                        <div class="col-12 col-md-6 col-xl-8 p-4 d-none d-md-block">
                            <div class="card adminuiux-card bg-theme-1-space position-relative overflow-hidden h-100">
                                <div class="position-absolute start-0 top-0 h-100 w-100 coverimg opacity-75 z-index-0"><img src="/use/assets/img/background-image/backgorund-image-8.jpg" alt="" /></div>
                                <div class="card-body position-relative z-index-1">
                                    <div class="row h-100 d-flex flex-column justify-content-center align-items-center gx-0 text-center">
                                        <div class="col-10 col-md-11 col-xl-8 mb-4 mx-auto">
                                            <div class="swiper swipernavpagination pb-5">
                                                <div class="swiper-wrapper">
                                                    <div class="swiper-slide">
                                                        <img src="/use/assets/img/investment/slider.png" alt="" class="mw-100 mb-3" />
                                                        <h2 class="text-white mb-3">Create and Manage your Investment appointments easily at your own very personalized space.</h2>
                                                        <p class="lead opacity-75">
                                                            You are at the best Adminuiux Investment UX<br />
                                                            HTML template demo preview
                                                        </p>
                                                    </div>
                                                    <div class="swiper-slide">
                                                        <img src="/use/assets/img/investment/slider.png" alt="" class="mw-100 mb-3" />
                                                        <h2 class="text-white mb-3">Create and Manage your Investment appointments easily at your own very personalized space.</h2>
                                                        <p class="lead opacity-75">
                                                            You are at the best Adminuiux Investment UX<br />
                                                            HTML template demo preview
                                                        </p>
                                                    </div>
                                                    <div class="swiper-slide">
                                                        <img src="/use/assets/img/investment/slider.png" alt="" class="mw-100 mb-3" />
                                                        <h2 class="text-white mb-3">Create and Manage your Investment appointments easily at your own very personalized space.</h2>
                                                        <p class="lead opacity-75">
                                                            You are at the best Adminuiux Investment UX<br />
                                                            HTML template demo preview
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="swiper-pagination white bottom-0"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        @include('layouts/user/scripts')

        <script>
            // Prevent back button navigation if user is authenticated
            window.history.pushState(null, "", window.location.href);
            window.onpopstate = function () {
                window.history.pushState(null, "", window.location.href);
            };
    
            @if (Auth::check())
                @if (Auth::user()->role === 'admin')
                    window.location.href = "{{ url('admin/dashboard') }}";
                @else
                    window.location.href = "{{ url('account/dashboard') }}";
                @endif
            @endif
        </script>
        
    </body>
</html>
