<x-adm>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="heading mb-0">Manage Virtual Cards</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row g-3">
                                        @foreach ($cards as $cards)
                                            <div class="col-sm-3">
                                            <div class="border border-secondary border-opacity-10 rounded p-3">
                                                <h6 class="fs-14 mb-3">{{$cards->user->firstname}} {{$cards->user->lastname}}<span class="badge badge-light rounded-pill text-bg-theme-accent-1 border-0 ms-2">{{$cards->card_status}}</span></h6>
                                                <div class="d-flex align-items-center mb-3">
                                                    <div class="clearfix me-2">
                                                    </div>
                                                    <div class="clearfix">
                                                        <h6 class="fs-13 mb-1">{{$cards->card_brand}} {{ implode(' ', str_split($cards->card_number, 4)) }}</h6>
                                                        <p class="fs-13 mb-0">Card expires at {{ \Carbon\Carbon::parse($cards->expiry_date)->format('m/y') }}</p>
                                                    </div>
                                                </div>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-outline-secondary btn-xs dropdown-toggle" data-bs-toggle="dropdown">Action</button>
                                                    <div class="dropdown-menu">
                                                        <form action="{{ route('admin.cards.approve', $cards->id) }}" method="POST">
                                                            @csrf
                                                            <button class="dropdown-item" type="submit">Approve</button>
                                                        </form>
                                                        <form action="{{ route('admin.cards.reject', $cards->id) }}" method="POST">
                                                            @csrf
                                                            <button class="dropdown-item" type="submit">Reject</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        
        </div>
    
    </div>


</x-adm>