<x-use>

    <div class="container-fluid mt-4">
        <div class="row gx-3 align-items-center">
            <div class="col-12 col-sm">
                <h5>Domestic Transfer</h5>
            </div>
        </div>
    </div>
    <div class="container mt-4">
        <div class="card adminuiux-card mb-4">
        
            <!-- Display validation errors -->
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        
            <!-- Loan Application Form -->
            <form action="{{ route('loans.apply') }}" method="POST">
                @csrf
                <div class="card-body">
                    <!-- Loan Type -->
                    <div class="mb-3">
                        <label for="loan_type" class="form-label">Loan Type</label>
                        <select name="loan_type" id="loan_type" class="form-control" required>
                            <option value="" disabled selected>Select Loan Type</option>
                            <option value="Personal">Personal</option>
                            <option value="Mortgage">Mortgage</option>
                            <option value="Auto">Auto</option>
                            <option value="Education">Education</option>
                        </select>
                    </div>
            
                    <!-- Loan Amount -->
                    <div class="mb-3" class="form-label">
                        <label for="loan_amount">Loan Amount</label>
                        <input type="number" name="loan_amount" id="loan_amount" class="form-control" min="100" step="0.01" placeholder="Enter loan amount" required>
                    </div>
            
                    <!-- Loan Term (in months) -->
                    <div class="mb-3" class="form-label">
                        <label for="loan_term">Loan Term (in months)</label>
                        <input type="number" name="loan_term" id="loan_term" class="form-control" min="1" placeholder="Enter loan term in months" required>
                    </div>
            
                    <!-- Interest Rate (automatically populated) -->
                    <div class="mb-3" class="form-label">
                        <label for="interest_rate">Interest Rate (%)</label>
                        <input type="number" name="interest_rate" id="interest_rate" value="15" class="form-control" readonly>
                    </div>
                    <div class="modal-footer mb-3">
                        <button type="submit" class="btn btn-theme">Apply</button>
                    </div>
                </div>
            </form>
                <!-- Submit Button -->
        </div>
    </div>
        
        <!-- JavaScript for fetching interest rate -->
        <script>
            document.getElementById('loan_type').addEventListener('change', fetchInterestRate);
            document.getElementById('loan_term').addEventListener('input', fetchInterestRate);
        
            function fetchInterestRate() {
                var loanType = document.getElementById('loan_type').value;
                var loanTerm = document.getElementById('loan_term').value;
        
                if (loanType && loanTerm) {
                    fetch(`/get-interest-rate/${loanType}/${loanTerm}`)
                        .then(response => response.json())
                        .then(data => {
                            document.getElementById('interest_rate').value = data.interest_rate;
                        });
                }
            }
        </script>
</x-use>