@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user>
    <div class="container-fluid mt-4">
        <div class="row gx-3 align-items-center">
            <div class="col-12 col-sm">
                <h5>Card Application</h5>
            </div>
        </div>
    </div>
    <div class="container mt-4">
        <div class="card adminuiux-card mb-4">
            <form action="{{ url('cards/store') }}" method="post">
                @csrf
                <div class="card-body">
                    <div>
                        <p class="h8 mb-2">Virtual Card Application</p>
                        <p class="text-secondary small mb-3">Your card application attracts a fee of {{Auth::user()->acct_currency}}{{$getSetting->card_fee}}.
                    </div>
                    <div class="mb-3">
                        <label for="formFile" class="form-label">Select Card Type</label> 
                        <select name="card_type" id="card_type" class="form-control" required>
                            <option value="">Select Card Type</option>
                            <option value="Debit">Debit</option>
                            <option value="Credit">Credit</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Select Card Brand</label> 
                        <select name="card_brand" id="card_brand" class="form-control" required>
                            <option value="">Select Card Brand</option>
                            <option value="Visa">Visa</option>
                            <option value="Mastercard">Mastercard</option>
                            <option value="Amex">American Express</option>
                            <option value="Discover">Discover</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Card Pin</label> 
                        <input type="password" name="card_pin" id="card_pin" class="form-control" placeholder="Enter 4-digit PIN" maxlength="4" required>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-theme">Apply</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
</x-user>