@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<x-user>
    <div class="container-fluid mt-4">
        <div class="row gx-3 align-items-center">
            <div class="col-12 col-sm">
                <h5>Virtual Cards</h5>
            </div>
            <div class="col-12 col-sm-auto text-end py-3 py-sm-0">
                <a href="{{ url('account/cards_apply')}}" class="btn btn-outline-primary">Apply</a>
            </div>
            <br>
            @if($card > 0)
            <div class="alert alert-info alert-dismissible fade show h8 text-center" role="alert">
                <i class="bi bi-cash-coin mb-0 h6"></i>
                You have <strong>{{ $card }}</strong> pending Card Applications</strong>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        </div>
    </div>

    <div class="container mt-4" id="main-content">
        <div class="row">
            <div class="col-12 col-md-6 col-lg-12 mb-4">
                <div class="card adminuiux-card overflow-hidden">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col"><h6>My Cards</h6></div>
                            <div class="col-auto px-0"></div>
                            <div class="col-auto"><a class="btn btn-sm btn btn-link">Manage</a></div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="swiper swipernav">
                            <div class="swiper-wrapper">
                                @foreach ($cards as $cards)
                                <div class="swiper-slide">
                                        <div class="card adminuiux-card bg-theme-1 overflow-hidden mx-auto width-300 mb-2">
                                        <div class="coverimg h-100 w-100 position-absolute top-0 start-0 z-index-0 opacity-50">
                                            <img src="/user/assets/img/modern-ai-image/flamingo-4.jpg" alt="" /></div>
                                        <div class="card-body z-index-1">
                                            <div class="row align-items-center mb-3">
                                                <div class="col-auto align-self-center"><i class="bi bi-credit-card fs-4"></i></div>
                                                <div class="col text-end">
                                                    <p>
                                                        <span class="small opacity-75">{{$getSetting->website_name}}</span><br />
                                                        <span class="">{{$cards->card_brand}} Card</span>
                                                    </p>
                                                </div>
                                            </div>
                                            <p class="h5 mb-4">{{ implode(' ', str_split($cards->card_number, 4)) }}</p>
                                            <div class="row">
                                                <div class="col-auto">
                                                    <p class="mb-0 small opacity-75">Expiry</p>
                                                    <p>{{ \Carbon\Carbon::parse($cards->expiry_date)->format('m/y') }}</p>
                                                </div>
                                                <div class="col text-end">
                                                    <p class="mb-0 small opacity-75">Card Holder</p>
                                                    <p>{{Auth::user()->firstname}} {{Auth::user()->lastname}}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    
                                    <div class="row gx-3 justify-content-center mb-2">
                                        <div class="col-sm-auto text-center">
                                            <p class="btn btn-link btn-square">Card Status:  <span>{{$cards->card_status}}</span></p>
                                        </div>
                                    </div>
                                    <ul class="list-group list-group-flush border-top bg-none">
                                        <li class="list-group-item">
                                            <div class="row gx-3 align-items-center">
                                                <div class="col">
                                                    <p class="mb-1 fw-medium">Name: </p>
                                                </div>
                                                <div class="col-auto text-end"><h6>{{Auth::user()->firstname}} {{Auth::user()->lastname}}</h6></div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="row gx-3 align-items-center">
                                                <div class="col">
                                                    <p class="mb-1 fw-medium">Card Number: </p>
                                                </div>
                                                <div class="col-auto text-end"><h6>{{$cards->card_number}}</h6></div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="row gx-3 align-items-center">
                                                <div class="col">
                                                    <p class="mb-1 fw-medium">Cvv: </p>
                                                </div>
                                                <div class="col-auto text-end"><h6>{{$cards->cvv}}</h6></div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="row gx-3 align-items-center">
                                                <div class="col">
                                                    <p class="mb-1 fw-medium">Expiry Date:</p>
                                                </div>
                                                <div class="col-auto text-end"><h6>{{ \Carbon\Carbon::parse($cards->expiry_date)->format('m/y') }}</h6></div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="row gx-3 align-items-center">
                                                <div class="col">
                                                    <p class="mb-1 fw-medium">Address:</p>
                                                </div>
                                                <div class="col-auto text-end"><h6>{{ Auth::user()->address}}</h6></div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</x-user>